import asyncio
import serial
import websockets

SERIAL_PORT = "/dev/ttys000"  # la tua porta virtuale
BAUD_RATE = 9600

async def handler(websocket):
    try:
        ser = serial.Serial(SERIAL_PORT, BAUD_RATE, timeout=1)
        print("🔌 Porta seriale aperta")

        async for message in websocket:
            print(f"🌐 Ricevuto dal client: {message}")
            if message == "PING":
                ser.write(b'PING\n')
                await asyncio.sleep(0.2)
                if ser.in_waiting:
                    response = ser.readline().strip()
                    print(f"📡 STM ha risposto: {response}")
                    if response == b'PING':
                        await websocket.send("PING")
                    else:
                        await websocket.send("INVALID")
                else:
                    await websocket.send("INVALID")

    except Exception as e:
        print(f"❌ Errore: {e}")
        await websocket.send("ERROR")

async def main():
    async with websockets.serve(handler, "localhost", 8765):
        print("🛰️ Server WebSocket avviato su ws://localhost:8765")
        await asyncio.Future()  # run forever

if __name__ == "__main__":
    asyncio.run(main())
